(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14026,        383]*)
(*NotebookOutlinePosition[     14732,        408]*)
(*  CellTagsIndexPosition[     14688,        404]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Ejercicio 1", "Subsubsection"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " Define una funci\[OAcute]n   \"telara\[NTilde]a[a_, x_, n_]\" de tres \
argumentos: el par\[AAcute]metro ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", el valor inicial ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1 = x\)]],
  " y n\[Element]\[DoubleStruckCapitalN], que cuando la ejecutes represente \
gr\[AAcute]ficamente en pantalla unidos por segmentos los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\((x\_k, x\_k)\), \ \((x\_k, g(x\_k))\), \ 
      \((g(x\_k), g(x\_k))\)\ \ 1 \[LessEqual] k \[LessEqual] n - 1\)]],
  " junto con las gr\[AAcute]ficas ",
  Cell[BoxData[
      \(TraditionalForm\`y = x, \ y = g(x)\)]],
  ". Especifica opciones de color (Hue[0]) y de tama\[NTilde]o \
(PointSize[0.015]) para los puntos y pasa las opciones de Plot a dicha funci\
\[OAcute]n (incluye opts___ en la definici\[OAcute]n de telara\[NTilde]a)).\n\
",
  StyleBox["b)",
    FontWeight->"Bold"],
  " Se dice que (para un valor de a) un punto ",
  StyleBox["x\[Element]",
    FontSlant->"Italic"],
  "[0,1] es un punto peri\[OAcute]dico de ",
  StyleBox["g",
    FontSlant->"Italic"],
  " con per\[IAcute]odo k\[GreaterEqual]2 si ",
  Cell[BoxData[
      \(TraditionalForm\`x = \(x\_1 = x\_\(k + 1\)\)\)]],
  " pero ",
  Cell[BoxData[
      \(TraditionalForm\`x\_j \[NotEqual] x\_1\)]],
  " para 1<j<k+1. Calcula un punto peri\[OAcute]dico con per\[IAcute]odo 4 \
para a=3.7 y calcula un punto peri\[OAcute]dico con per\[IAcute]odo 8 para \
a=4.  Representa las gr\[AAcute]ficas de las sucesiones correspondientes con \
el comando \"telara\[NTilde]a\"."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsubsection"],

Cell[BoxData[
    \(\(g[a_]\)[t_] := a*t*\((1 - t)\)\)], "Input"],

Cell["\<\
El siguiente comando es m\[AAcute]s general que el que se pide pues es v\
\[AAcute]lido para cualquier funci\[OAcute]n.\
\>", "Text"],

Cell[BoxData[
    \(\(graficaiteradas[f_, {b_, c_}, a_, n_, opts___] := 
      Module[{x, iteradas, graf1, graf2, graf3, segmentos}, 
        \[IndentingNewLine]iteradas = NestList[f, a, n - 1]; 
        \[IndentingNewLine] (*\ 
          los\ primeros\ n\ t\[EAcute]rminos\ de\ la\ sucesi\[OAcute]n\ 
              x[k + 1] = \(f[x[k]]\ empezando\ en\ x[1] = a\)\ *) 
          \[IndentingNewLine]graf1 = 
          Plot[{f[x], x}, {x, b, c}, DisplayFunction \[Rule] Identity]; 
        \[IndentingNewLine] (*\ 
          la\ gr\[AAcute]fica\ de\ f\ en\ el\ intervalo\ [b, c]\ *) 
          \[IndentingNewLine]segmentos[x_] := {Line[{{x, x}, {x, f[x]}}], 
            Line[{{x, f[x]}, {f[x], f[x]}}]}; 
        \[IndentingNewLine] (*\ 
          segmento\ vertical\ de\ la\ diagonal\ a\ la\ gr\[AAcute]fica\ de\ f
            \ seguido\ de\ segmento\ horizontal\ a\ la\ diagonal\ *) 
          \[IndentingNewLine]graf2 = Graphics[segmentos/@iteradas]; 
        \[IndentingNewLine] (*\ 
          la\ gr\[AAcute]fica\ de\ dichos\ segmentos\ *) 
          \[IndentingNewLine]graf3 = 
          Graphics[{Hue[0], PointSize[ .015], 
              Point/@Transpose[{iteradas, iteradas}]}]; 
        \[IndentingNewLine] (*\ 
          la\ gr\[AAcute]fica\ de\ los\ puntos\ sobre\ la\ diagonal\ *) 
          \[IndentingNewLine]Show[graf1, graf2, graf3, 
          DisplayFunction \[Rule] $DisplayFunction, opts]]; \)\)], "Input"],

Cell["Modificamos el comando anterior en la forma pedida.", "Text"],

Cell[BoxData[
    \(\(telara\[NTilde]a[a_, x_, n_, opts___] := 
      Module[{t, iteradas, graf1, graf2, graf3, segmentos}, 
        \[IndentingNewLine]iteradas = NestList[g[a], x, n - 1]; 
        \[IndentingNewLine] (*\ 
          los\ primeros\ n\ t\[EAcute]rminos\ de\ la\ sucesi\[OAcute]n\ 
              x[k + 1] = \(f[x[k]]\ empezando\ en\ x[1] = x\)\ *) 
          \[IndentingNewLine]graf1 = 
          Plot[{\(g[a]\)[t], t}, {t, 0, 1}, 
            DisplayFunction \[Rule] Identity]; 
        \[IndentingNewLine] (*\ 
          la\ gr\[AAcute]fica\ de\ g[a] en\ el\ intervalo\ [0, 1]\ *) 
          \[IndentingNewLine]segmentos[t_] := 
          Line[{{t, t}, {t, \(g[a]\)[t]}, {\(g[a]\)[t], \(g[a]\)[t]}}]; 
        \[IndentingNewLine] (*\ 
          segmento\ vertical\ de\ la\ diagonal\ a\ la\ gr\[AAcute]fica\ de\ 
            g[a]\ seguido\ de\ segmento\ horizontal\ a\ la\ diagonal\ *) 
          \[IndentingNewLine]graf2 = Graphics[segmentos/@iteradas]; 
        \[IndentingNewLine] (*\ 
          la\ gr\[AAcute]fica\ de\ dichos\ segmentos\ *) 
          \[IndentingNewLine]graf3 = 
          Graphics[{Hue[0], PointSize[ .015], 
              Point/@Transpose[{iteradas, iteradas}]}]; 
        \[IndentingNewLine] (*\ 
          la\ gr\[AAcute]fica\ de\ los\ puntos\ sobre\ la\ diagonal\ *) 
          \[IndentingNewLine]Show[graf1, graf2, graf3, 
          DisplayFunction \[Rule] $DisplayFunction, opts]]; \)\)], "Input"],

Cell[BoxData[
    \(\(telara\[NTilde]a[2.7, 0.036, 10, AspectRatio \[Rule] 1]; \)\)], 
  "Input"],

Cell[BoxData[
    \(periodo4 = x /. FindRoot[Nest[g[3.7], x, 4] == x, {x,  .6}]\)], "Input"],

Cell[BoxData[
    \(\(telara\[NTilde]a[3.7, periodo4, 4]; \)\)], "Input"],

Cell[BoxData[
    \(NestList[g[3.7], periodo4, 4]\)], "Input"],

Cell[BoxData[
    \(periodo8 = x /. FindRoot[Nest[g[4], x, 8] == x, {x,  .6}]\)], "Input"],

Cell[BoxData[
    \(\(telara\[NTilde]a[4, periodo8, 8]; \)\)], "Input"],

Cell[BoxData[
    \(NestList[g[4], periodo8, 8]\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Subsubsection"],

Cell[TextData[{
  "En este ejercicio se trata de estudiar la sucesi\[OAcute]n  ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(n + 1\) = a\ x\_n\ \((1 - x\_n)\)\)]],
  " para un valor fijo de ",
  StyleBox["a ",
    FontSlant->"Italic"],
  "cuando el valor inicial ",
  Cell[BoxData[
      \(TraditionalForm\`x\_1 = x \[Element] \ \([0, 1]\)\)]],
  " se mueve en un intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([u, v]\)\)]],
  ". Para mayor fiabilidad desecharemos los primeros m t\[EAcute]rminos de \
cada sucesi\[OAcute]n pues estos pueden tener un comportamiento transitorio \
poco significativo. Para ello debes definir una funci\[OAcute]n teniendo en \
cuenta los siguientes puntos:\n1 Elegimos un valor del par\[AAcute]metro ",
  StyleBox["a",
    FontSlant->"Italic"],
  " (por tanto debes incluir ",
  StyleBox["a",
    FontSlant->"Italic"],
  " como variable).\n2 Elegimos un intervalo 0\[LessEqual]u<v\[LessEqual]1 \
(por tanto debes incluir ",
  StyleBox["u, v",
    FontSlant->"Italic"],
  " como variables).\n3 Dividimos el intervalo [u,v] en partes iguales de \
longitud inc (por tanto debes incluir ",
  StyleBox["inc",
    FontSlant->"Italic"],
  " como variable). \n4 En total tendremos ",
  StyleBox["(v-u)/",
    FontSlant->"Italic"],
  "inc + 1 puntos de divisi\[OAcute]n de [u,v] que representaremos por ",
  Cell[BoxData[
      \(TraditionalForm\`x\_j\)]],
  " con ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] j \[LessEqual] \((v - u)\)/inc\)]],
  ". Representaremos por ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(j, q + 1\) = \(g[a]\)[x\_\(j, q\)]\)]],
  " (q=1,2,3...) la sucesi\[OAcute]n que se obtiene iterando la \
funci\[OAcute]n g[a] partiendo del valor inicial ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(j, 1\) = x\_j\)]],
  ". Elegimos un valor de m\[Element]\[DoubleStruckCapitalN] y calculamos el \
t\[EAcute]rmino m+1-\[EAcute]simo ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(j, m + 1\)\)]],
  " de cada una de dichas sucesiones (por tanto debes incluir ",
  StyleBox["m",
    FontSlant->"Italic"],
  " como variable).\n5 Tomando como valor inicial cada uno de los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(j, m + 1\)\)]],
  " calculados en el apartado anterior, iteraremos la funci\[OAcute]n g[a] \
n-1 veces para obtener una lista con los t\[EAcute]rminos ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(j, m + 1\), \ x\_\(j, m + 2\),  ... , \ 
      x\_\(j, m + n\)\)]],
  " de cada una de dichas sucesiones (por tanto debes incluir ",
  StyleBox["n",
    FontSlant->"Italic"],
  " como variable). Puedes llamar a esa lista \"iteraciones[a_, {u_, v_, \
inc_}, m_, n_]\".\n6 Ahora hay que formar una lista con los puntos ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((u + j\ inc, \ x\_\(j, m + k\))\)\ \)\)]],
  "donde para cada valor de ",
  StyleBox["j",
    FontSlant->"Italic"],
  " con ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] j \[LessEqual] \((v - u)\)/inc\)]],
  " se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`1 \[LessEqual] k \[LessEqual] n\)]],
  ". A esta lista la puedes llamar \"puntos[a_, {u_, v_, inc_}, m_, n_]\".\n",
  
  "Finalmente, con ListPlot (con las opciones \
PlotStyle\[Rule]AbsolutePointSize[0.0001], PlotRange\[Rule]All), representa \
gr\[AAcute]ficamente la lista anterior para valores de ",
  StyleBox["a",
    FontSlant->"Italic"],
  " igual a 2, 3.3, 3.5, 3.56 y 3.7 eligiendo u=0, v=1, inc=.01, m=n=100 y \
comenta los resultados obtenidos. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsubsection"],

Cell["\<\
Con las sugerencias que se dan es inmediato definir los siguientes \
comandos:\
\>", "Text"],

Cell[BoxData[
    \(iteraciones[a_, {u_, v_, inc_}, m_, n_] := 
      Transpose[NestList[g[a], Nest[g[a], Range[u, v, inc], m + 1], n - 1]]
        \)], "Input"],

Cell[BoxData[
    \(puntos[a_, {u_, v_, inc_}, m_, n_] := 
      Union[Flatten[
          Inner[List, Range[u, v, inc], iteraciones[a, {u, v, inc}, m, n], 
            List], 1]]\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[puntos[2, {0, 1,  .01}, 100, 100], 
      PlotStyle \[Rule] AbsolutePointSize[0.0001], \ PlotRange \[Rule] All]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[puntos[3.3, {0, 1,  .01}, 100, 100], 
      PlotStyle \[Rule] AbsolutePointSize[0.0001], \ PlotRange \[Rule] All]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[puntos[3.5, {0, 1,  .01}, 100, 100], 
      PlotStyle \[Rule] AbsolutePointSize[0.0001], \ PlotRange \[Rule] All]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[puntos[3.56, {0, 1,  .01}, 100, 100], 
      PlotStyle \[Rule] AbsolutePointSize[0.0001], \ PlotRange \[Rule] All]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[puntos[3.7, {0, 1,  .01}, 100, 100], 
      PlotStyle \[Rule] AbsolutePointSize[0.0001], \ PlotRange \[Rule] All]; 
    \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Subsubsection"],

Cell[TextData[{
  "Modificando de manera apropiada las funciones definidas en el ejercicio \
anterior, define una funci\[OAcute]n \"bifurcacion[{a0_, a1_, inc_}, x_, m_, \
n_]\" que proporcione como salida una lista con los puntos ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"(", 
            RowBox[{\(a\_j\), ",", 
              FormBox[\(x\_\(j, m + k\)\),
                "TraditionalForm"]}], ")"}]}], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] j \[LessEqual] \((a1 - a0)\)/inc\)]],
  ", 1\[LessEqual]k\[LessEqual]n, donde ",
  Cell[BoxData[
      \(TraditionalForm\`a\_j = a0 + j\ inc\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`x\_\(j, q + 1\) = \(g[a\_j]\)[x\_\(j, q\)]\)]],
  ". Representa bifurcacion[{0, 4, .01}, .4, 100, 100] y bifurcacion[{3.8, \
3.9, .001}, .4, 100, 100]. Comenta los resultados obtenidos."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Soluci\[OAcute]n", "Subsubsection"],

Cell[BoxData[
    \(nuevasiteraciones[{a0_, a1_, inc_}, x_, m_, n_] := 
      Transpose[
        NestList[g[Range[a0, a1, inc]], 
          Nest[g[Range[a0, a1, inc]], x, m + 1], n - 1]]\)], "Input"],

Cell[BoxData[
    \(bifurcacion[{a0_, a1_, inc_}, x_, m_, n_] := 
      Union[Flatten[
          Inner[List, Range[a0, a1, inc], 
            nuevasiteraciones[{a0, a1, inc}, x, m, n], List], 1]]\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[bifurcacion[{0, 4,  .01},  .4, 100, 100], 
      PlotStyle \[Rule] AbsolutePointSize[0.0001], \ PlotRange \[Rule] All]; 
    \)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[bifurcacion[{3.8, 3.9,  .001},  .4, 100, 100], 
      PlotStyle \[Rule] AbsolutePointSize[0.0001], \ PlotRange \[Rule] All]; 
    \)\)], "Input"]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1152}, {0, 799}},
WindowSize->{1123, 724},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 36, 0, 55, "Subsubsection"],
Cell[1770, 53, 1633, 40, 209, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3440, 98, 41, 0, 55, "Subsubsection"],
Cell[3484, 100, 65, 1, 72, "Input"],
Cell[3552, 103, 143, 3, 41, "Text"],
Cell[3698, 108, 1424, 25, 410, "Input"],
Cell[5125, 135, 67, 0, 41, "Text"],
Cell[5195, 137, 1441, 26, 384, "Input"],
Cell[6639, 165, 97, 2, 72, "Input"],
Cell[6739, 169, 92, 1, 72, "Input"],
Cell[6834, 172, 73, 1, 72, "Input"],
Cell[6910, 175, 62, 1, 72, "Input"],
Cell[6975, 178, 90, 1, 72, "Input"],
Cell[7068, 181, 71, 1, 72, "Input"],
Cell[7142, 184, 60, 1, 72, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7239, 190, 36, 0, 55, "Subsubsection"],
Cell[7278, 192, 3512, 86, 515, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10827, 283, 41, 0, 55, "Subsubsection"],
Cell[10871, 285, 102, 3, 41, "Text"],
Cell[10976, 290, 161, 3, 98, "Input"],
Cell[11140, 295, 191, 4, 98, "Input"],
Cell[11334, 301, 164, 3, 98, "Input"],
Cell[11501, 306, 166, 3, 98, "Input"],
Cell[11670, 311, 166, 3, 98, "Input"],
Cell[11839, 316, 167, 3, 98, "Input"],
Cell[12009, 321, 166, 3, 98, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12212, 329, 36, 0, 55, "Subsubsection"],
Cell[12251, 331, 915, 22, 93, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13203, 358, 41, 0, 55, "Subsubsection"],
Cell[13247, 360, 199, 4, 98, "Input"],
Cell[13449, 366, 208, 4, 98, "Input"],
Cell[13660, 372, 171, 3, 98, "Input"],
Cell[13834, 377, 176, 3, 98, "Input"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

